/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.StringUtils;

public class StringUtil {
    private static final String encoding = "UTF-8";
    private static final String RSA_ALGORITHM = "RSA";
    private static final String RSA_PANDING_TYPE = "RSA/ECB/PKCS1Padding";

    public static String createLinkString(Map<String, Object> params) {
        String[] sortedKeys;
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : sortedKeys = StringUtil.getSortedArray(params)) {
            if (key == null || key.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            sb.append(key + "=" + params.get(key) + "&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String[] getSortedArray(Map<String, Object> params) {
        Object[] key_arr = params.keySet().toArray(new String[0]);
        Arrays.sort(key_arr);
        return key_arr;
    }

    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        Field[] declaredFields;
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : declaredFields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    public static String buildQuery(Map<String, Object> query) {
        if (query == null || query.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean appended = false;
        for (Map.Entry<String, Object> entry : query.entrySet()) {
            if (entry == null) continue;
            if (appended) {
                builder.append("&");
            } else {
                appended = true;
            }
            if (entry.getValue() instanceof List) {
                for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                    builder.append(entry.getKey());
                    builder.append("=");
                    builder.append(((List)entry.getValue()).get(i).toString());
                    if (i >= ((List)entry.getValue()).size() - 1) continue;
                    builder.append("&");
                }
                continue;
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue().toString());
        }
        return builder.toString();
    }

    public static String getSHA256StrJava(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(encoding));
            encodeStr = StringUtil.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static String buildUrl(String path, String query) {
        if (StringUtils.isEmpty((Object)query)) {
            return path;
        }
        return path + "?" + query;
    }

    public static PublicKey getPublicKey(String key) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64((byte[])key.getBytes()));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        return publicKey;
    }

    public static String encrypt(String source, String publicKey) throws Exception {
        PublicKey key = StringUtil.getPublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(RSA_ALGORITHM);
        cipher.init(1, key);
        byte[] b = source.getBytes();
        byte[] b1 = cipher.doFinal(b);
        return new String(Base64.encodeBase64((byte[])b1), encoding);
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(RSA_PANDING_TYPE);
        cipher.init(1, publicK);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 244 ? cipher.doFinal(data, offSet, 244) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 244;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static String encryptByPublicKey(String data, String publicKey) throws Exception {
        return Base64.encodeBase64String((byte[])StringUtil.encryptByPublicKey(data.getBytes(), publicKey));
    }
}

