/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.ResponseGetAdministrativeClassDetailResModel;
import com.xiaobao.client.model.ResponseGetElectiveClassDetailResModel;
import com.xiaobao.client.model.ResponsePageResultGetAdministrativeClassListResModel;
import com.xiaobao.client.model.ResponsePageResultGetElectiveClassListResModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class ClassApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public ClassApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponseGetAdministrativeClassDetailResModel getAdministrativeClassDetail(Long classId) throws ApiException {
        if (null == classId) {
            throw new ApiException("classId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Class/v2/GetAdministrativeClassDetail";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != classId) {
            queryParam.put("classId", classId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseGetAdministrativeClassDetailResModel)JSONObject.parseObject((String)result, ResponseGetAdministrativeClassDetailResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponsePageResultGetAdministrativeClassListResModel getAdministrativeClassList(Integer gradeCode, Integer pageIndex, Integer pageSize) throws ApiException {
        String url = "";
        String path = "/open-platform/Class/v2/GetAdministrativeClassList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != gradeCode) {
            queryParam.put("gradeCode", gradeCode);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetAdministrativeClassListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetAdministrativeClassListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseGetElectiveClassDetailResModel getElectiveClassDetail(Long classId) throws ApiException {
        if (null == classId) {
            throw new ApiException("classId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Class/v2/GetElectiveClassDetail";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != classId) {
            queryParam.put("classId", classId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseGetElectiveClassDetailResModel)JSONObject.parseObject((String)result, ResponseGetElectiveClassDetailResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponsePageResultGetElectiveClassListResModel getElectiveClassList(Integer gradeCode, Integer pageIndex, Integer pageSize) throws ApiException {
        String url = "";
        String path = "/open-platform/Class/v2/GetElectiveClassList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != gradeCode) {
            queryParam.put("gradeCode", gradeCode);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetElectiveClassListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetElectiveClassListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

