/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.ResponseGetClueDetailResModel;
import com.xiaobao.client.model.ResponsePageResultGetClueListResModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class ClueApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public ClueApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponseGetClueDetailResModel getClueDetail(Long clueId) throws ApiException {
        if (null == clueId) {
            throw new ApiException("clueId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Clue/v2/GetClueDetail";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != clueId) {
            queryParam.put("clueId", clueId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseGetClueDetailResModel)JSONObject.parseObject((String)result, ResponseGetClueDetailResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponsePageResultGetClueListResModel getClueList(Date beginTime, Date endTime, String key, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == beginTime) {
            throw new ApiException("beginTime must not be null.");
        }
        if (null == endTime) {
            throw new ApiException("endTime must not be null.");
        }
        String url = "";
        String path = "/open-platform/Clue/v2/GetClueList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != beginTime) {
            queryParam.put("beginTime", dateFormat.format(beginTime));
        }
        if (null != endTime) {
            queryParam.put("endTime", dateFormat.format(endTime));
        }
        if (null != key) {
            queryParam.put("key", key);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetClueListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetClueListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

