/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.CreateAttendanceDataReqModel;
import com.xiaobao.client.model.CreateOcpDeviceReqModel;
import com.xiaobao.client.model.DeleteDevicesReqModel;
import com.xiaobao.client.model.ResponseBoolean;
import com.xiaobao.client.model.ResponseListCreateOcpDeviceResModel;
import com.xiaobao.client.model.ResponseListGetOcpDeviceResModel;
import com.xiaobao.client.model.UpdateOcpDeviceReqModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;

public class OcpApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public OcpApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponseBoolean createAttendanceData(List<CreateAttendanceDataReqModel> list) throws ApiException {
        if (null == list) {
            throw new ApiException("list must not be null.");
        }
        String url = "";
        String path = "/open-platform/Ocp/v2/CreateAttendanceData";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        String bodyStr = JSON.toJSONString(list);
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doPost(url, path, bodyStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseBoolean)JSONObject.parseObject((String)result, ResponseBoolean.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseListCreateOcpDeviceResModel createDevices(List<CreateOcpDeviceReqModel> list) throws ApiException {
        if (null == list) {
            throw new ApiException("list must not be null.");
        }
        String url = "";
        String path = "/open-platform/Ocp/v2/CreateDevices";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        String bodyStr = JSON.toJSONString(list);
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doPost(url, path, bodyStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseListCreateOcpDeviceResModel)JSONObject.parseObject((String)result, ResponseListCreateOcpDeviceResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseBoolean deleteDevices(DeleteDevicesReqModel req) throws ApiException {
        if (null == req) {
            throw new ApiException("req must not be null.");
        }
        String url = "";
        String path = "/open-platform/Ocp/v2/DeleteDevices";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        String bodyStr = JSON.toJSONString((Object)req);
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doPost(url, path, bodyStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseBoolean)JSONObject.parseObject((String)result, ResponseBoolean.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseListGetOcpDeviceResModel getDeviceList() throws ApiException {
        String url = "";
        String path = "/open-platform/Ocp/v2/GetDeviceList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseListGetOcpDeviceResModel)JSONObject.parseObject((String)result, ResponseListGetOcpDeviceResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseBoolean updateDevices(List<UpdateOcpDeviceReqModel> list) throws ApiException {
        if (null == list) {
            throw new ApiException("list must not be null.");
        }
        String url = "";
        String path = "/open-platform/Ocp/v2/UpdateDevices";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        String bodyStr = JSON.toJSONString(list);
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doPost(url, path, bodyStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseBoolean)JSONObject.parseObject((String)result, ResponseBoolean.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

