/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.ResponsePageResultGetActivityListResModel;
import com.xiaobao.client.model.ResponsePageResultGetCalendarListResModel;
import com.xiaobao.client.model.ResponsePageResultGetCourseScheduleListResModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class ScheduleApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public ScheduleApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponsePageResultGetActivityListResModel getActivityList(Date beginTime, Date endTime, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == beginTime) {
            throw new ApiException("beginTime must not be null.");
        }
        if (null == endTime) {
            throw new ApiException("endTime must not be null.");
        }
        String url = "";
        String path = "/open-platform/Schedule/v2/GetActivityList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != beginTime) {
            queryParam.put("beginTime", dateFormat.format(beginTime));
        }
        if (null != endTime) {
            queryParam.put("endTime", dateFormat.format(endTime));
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetActivityListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetActivityListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponsePageResultGetCalendarListResModel getCalendarList(Date beginTime, Date endTime, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == beginTime) {
            throw new ApiException("beginTime must not be null.");
        }
        if (null == endTime) {
            throw new ApiException("endTime must not be null.");
        }
        String url = "";
        String path = "/open-platform/Schedule/v2/GetCalendarList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != beginTime) {
            queryParam.put("beginTime", dateFormat.format(beginTime));
        }
        if (null != endTime) {
            queryParam.put("endTime", dateFormat.format(endTime));
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetCalendarListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetCalendarListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponsePageResultGetCourseScheduleListResModel getCourseScheduleList(Date beginTime, Date endTime, Long playGroundId, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == beginTime) {
            throw new ApiException("beginTime must not be null.");
        }
        if (null == endTime) {
            throw new ApiException("endTime must not be null.");
        }
        String url = "";
        String path = "/open-platform/Schedule/v2/GetCourseScheduleList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != beginTime) {
            queryParam.put("beginTime", dateFormat.format(beginTime));
        }
        if (null != endTime) {
            queryParam.put("endTime", dateFormat.format(endTime));
        }
        if (null != playGroundId) {
            queryParam.put("playGroundId", playGroundId);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetCourseScheduleListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetCourseScheduleListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

