/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.ResponseGetStudentDetailResModel;
import com.xiaobao.client.model.ResponseIListGetFamilyResModel;
import com.xiaobao.client.model.ResponsePageResultGetClassStudentListResModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class StudentApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public StudentApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponsePageResultGetClassStudentListResModel getClassStudentList(Long classId, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == classId) {
            throw new ApiException("classId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Student/v2/GetClassStudentList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != classId) {
            queryParam.put("classId", classId);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetClassStudentListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetClassStudentListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseIListGetFamilyResModel getFamily(Long studentId) throws ApiException {
        if (null == studentId) {
            throw new ApiException("studentId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Student/v2/GetFamily";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != studentId) {
            queryParam.put("studentId", studentId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseIListGetFamilyResModel)JSONObject.parseObject((String)result, ResponseIListGetFamilyResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseGetStudentDetailResModel getStudentDetail(Long studentId) throws ApiException {
        if (null == studentId) {
            throw new ApiException("studentId must not be null.");
        }
        String url = "";
        String path = "/open-platform/Student/v2/GetStudentDetail";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != studentId) {
            queryParam.put("studentId", studentId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseGetStudentDetailResModel)JSONObject.parseObject((String)result, ResponseGetStudentDetailResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

