/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.api;

import com.alibaba.fastjson.JSONObject;
import com.xiaobao.client.ApiException;
import com.xiaobao.client.StringUtil;
import com.xiaobao.client.model.ResponseGetUserDetailResModel;
import com.xiaobao.client.model.ResponsePageResultGetDepartmentUserListResModel;
import com.xiaobao.client.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class UserApi {
    private String apiUrl;
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private String corpId;
    private String signMethod = "sha256";

    public UserApi(String apiUrl, String accessKeyId, String accessKeySecret, String token, String corpId) {
        this.apiUrl = apiUrl;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.token = token;
        this.corpId = corpId;
    }

    public ResponsePageResultGetDepartmentUserListResModel getDepartmentUserList(Long departmentId, Integer pageIndex, Integer pageSize) throws ApiException {
        if (null == departmentId) {
            throw new ApiException("departmentId must not be null.");
        }
        String url = "";
        String path = "/open-platform/User/v2/GetDepartmentUserList";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != departmentId) {
            queryParam.put("departmentId", departmentId);
        }
        if (null != pageIndex) {
            queryParam.put("pageIndex", pageIndex);
        }
        if (null != pageSize) {
            queryParam.put("pageSize", pageSize);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponsePageResultGetDepartmentUserListResModel)JSONObject.parseObject((String)result, ResponsePageResultGetDepartmentUserListResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }

    public ResponseGetUserDetailResModel getUserDetail(Long orgUserId) throws ApiException {
        if (null == orgUserId) {
            throw new ApiException("orgUserId must not be null.");
        }
        String url = "";
        String path = "/open-platform/User/v2/GetUserDetail";
        url = this.apiUrl + path;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (null != orgUserId) {
            queryParam.put("orgUserId", orgUserId);
        }
        String paramStr = StringUtil.buildQuery(queryParam);
        url = StringUtil.buildUrl(url, paramStr);
        try {
            String result = HttpUtil.doGet(url, path, paramStr, this.accessKeyId, this.accessKeySecret, this.token, this.corpId);
            return (ResponseGetUserDetailResModel)JSONObject.parseObject((String)result, ResponseGetUserDetailResModel.class);
        }
        catch (Exception e) {
            throw new ApiException("httpUtil post error");
        }
    }
}

