/*
 * Decompiled with CFR 0.152.
 */
package com.xiaobao.client.util;

import com.xiaobao.client.StringUtil;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final String signMethod = "sha256";
    private static final String getMethod = "GET";
    private static final String postMethod = "POST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String path, String paramStr, String accessKeyId, String accessKeySecret, String token, String corpId) throws Exception {
        String xbTimestamp = String.valueOf(new Date().getTime());
        String sign = HttpUtil.getSign(postMethod, accessKeyId, xbTimestamp, path, paramStr, accessKeySecret);
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/json");
        httpPost.setHeader("xb-timestamp", xbTimestamp);
        httpPost.setHeader("xb-sign-method", signMethod);
        httpPost.setHeader("xb-sign", sign);
        httpPost.setHeader("token", token);
        httpPost.setHeader("corp-id", corpId);
        StringEntity se = new StringEntity(paramStr, "UTF-8");
        httpPost.setEntity((HttpEntity)se);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        httpPost.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            HttpEntity resEntity;
            response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpClient.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, String path, String paramStr, String accessKeyId, String accessKeySecret, String token, String corpId) throws Exception {
        String xbTimestamp = String.valueOf(new Date().getTime());
        String sign = HttpUtil.getSign(getMethod, accessKeyId, xbTimestamp, path, paramStr, accessKeySecret);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = null;
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Content-Type", "application/json");
        httpGet.setHeader("xb-timestamp", xbTimestamp);
        httpGet.setHeader("xb-sign-method", signMethod);
        httpGet.setHeader("xb-sign", sign);
        httpGet.setHeader("token", token);
        httpGet.setHeader("corp-id", corpId);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = null;
        try {
            HttpEntity resEntity;
            response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                response.close();
            }
            httpClient.close();
        }
        return result;
    }

    private static String getSign(String methodName, String accessKeyId, String xbTimestamp, String path, String paramStr, String accessKeySecret) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(signMethod).append(methodName).append(accessKeyId).append(xbTimestamp).append(path.replace("/", "")).append(paramStr).append(accessKeySecret);
        String sign = StringUtil.getSHA256StrJava(stringBuilder.toString());
        return sign;
    }
}

